package cn.com.duiba.kjy.livecenter.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.agent.LiveAgentSpecifyAwardDto;
import cn.com.duiba.kjy.livecenter.api.param.agent.LiveAgentSpecifyAwardSearchParam;

import java.util.List;

/**
 * 直播代理人指定中奖rpc接口
 * @author 吴文哲
 * @date 2020-09-06 14:31
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentSpecifyAwardService {

    /**
     * 新增代理人指定访客中奖记录
     *
     * @param addDto 新增对象
     * @return 主键
     */
    Long addAgentSpecifyAward(LiveAgentSpecifyAwardDto addDto);

    /**
     * 根据直播间id  代理人id 统计 指定中奖数量
     *
     * @return 指定中奖数量
     */
    int countByCondition(LiveAgentSpecifyAwardSearchParam param);

    /**
     * 根据条件查询列表
     * @param param 条件
     * @return 代理人指定中奖记录列表
     */
    List<LiveAgentSpecifyAwardDto> findByCondition(LiveAgentSpecifyAwardSearchParam param);
}
