package cn.com.duiba.kjy.livecenter.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.conf.BackgroundMusicDto;

import java.util.List;

/**
 * 背景音乐
 * @author lizhi
 * @date 2020/6/28 5:43 PM
 */
@AdvancedFeignClient
public interface RemoteBackgroundMusicService {

    /**
     * 查询公司配置的bgm
     * @param companyId 公司ID
     * @return 背景音乐集合
     */
    List<BackgroundMusicDto> findListByCompanyId(Long companyId);

    /**
     * 查询公司配置的bgm
     * @param companyIds 公司ID集合
     * @return 背景音乐集合
     */
    List<BackgroundMusicDto> findListByCompanyIds(List<Long> companyIds);
}
