package cn.com.duiba.kjy.livecenter.api.remoteservice.resources;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.liveResource.FormResourceDto;
import cn.com.duiba.kjy.livecenter.api.dto.liveResource.ResourceDto;
import cn.com.duiba.kjy.livecenter.api.param.liveResource.ResourceSearchParam;

import java.util.List;

/**
 * 资源服务类
 * @author 吴文哲
 * @date 2020-04-01 13:57
 **/
@AdvancedFeignClient
public interface RemoteResourceService {

    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播资料库集合
     */
    List<ResourceDto> findPage(ResourceSearchParam param);

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播资料库集合
     */
    List<ResourceDto> findList(ResourceSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long findCount(ResourceSearchParam param);

    /**
     * 新增/修改资源
     * @param dto
     * @return
     */
    Long saveResource(ResourceDto dto);


    /**
     * 根据主键逻辑删除
     * @param id
     * @return
     */
    Integer delById(Long id);


    /**
     * 根据主键查询
     * @param id
     * @return
     */
    ResourceDto findById(Long id);

    /**
     * 根据主键查询
     * @param ids
     * @return
     */
    List<ResourceDto> findByIds(List<Long> ids);

    /**
     * 保存/修改表单资料
     *
     * @param dto 表单资料
     * @return true-成功 false-失败
     */
    Long saveFormResource(FormResourceDto dto);
}
