package cn.com.duiba.kjy.livecenter.api.dto.statistics;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播访客数据统计表
 * @author kjj mybatis generator
 * @date 2020-04-03
 */
@Data
public class LiveStatisticsUserDto implements Serializable {

    private static final long serialVersionUID = 15858970463631438L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * tb_live_agent.id
     */
    private Long agentId;

    /**
     * tb_live_user.id
     */
    private Long userId;

    /**
     * 领取权益数量
     */
    private Integer welfareNum;

    /**
     * 领取资料数量
     */
    private Integer resourceNum;

    /**
     * 提问数量
     */
    private Integer questionNum;

    /**
     * 评论数量
     */
    private Integer speakNum;

    /**
     * 分享数量
     */
    private Integer shareNum;

    /**
     * 点赞数量
     */
    private Integer likeNum;

    /**
     * 累计观看时长
     */
    private Integer duration;

    /**
     * 是否关注  0:未关注 1:关注
     */
    private Integer subscribe;

    /**
     * 咨询数
     */
    private Integer adviceNum;

    /**
     * 已读标识 0：未读 1：已读
     * @see cn.com.duiba.kjy.livecenter.api.enums.BooleanEnum
     */
    private Integer readFlag;


    /**
     * 线索得分
     */
    private Integer clueScore;

    /**
     * 线索等级
     */
    private Integer clueLevel;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * 选择题回答数量
     */
    private Integer choiceQuestionNum;

    /**
     * 报名数量（目前只有表单资料）
     */
    private Integer registrationNum;
}
