package cn.com.duiba.kjy.livecenter.api.param.live.share;

import cn.com.duiba.kjy.livecenter.api.enums.live.share.LiveShareTypeEnum;
import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 直播分享配置
 * @author kjj mybatis generator 
 * @date 2020-08-08
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveShareConfSearchParam extends PageQuery {

    private static final long serialVersionUID = 15968703368411448L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID，对应tb_live.id
     */
    private Long liveId;

    /**
     * 分享类型：1-普通小程序分享，2-手气王小程序分享
     * @see LiveShareTypeEnum
     */
    private Integer shareType;

    /**
     * 是否已删除：0-未删除，1-已删除
     * @see cn.com.duiba.kjy.livecenter.api.enums.DeletedEnum
     */
    private Integer deleted;

}