package cn.com.duiba.kjy.livecenter.api.remoteservice.form;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.form.FormFieldDto;
import cn.com.duiba.kjy.livecenter.api.param.form.FormFieldSearchParam;

import java.util.List;

/**
 * 表单字段rpc服务
 *
 * @author xuzhigang
 * @date 2020/7/27 5:27 下午
 **/
@AdvancedFeignClient
public interface RemoteFormFieldService {
    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 单字段集合
     */
    List<FormFieldDto> selectList(FormFieldSearchParam param);

    /**
     * 查询表单配置
     * @return 单字段集合
     */
    List<FormFieldDto> selectAllList();

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    long selectCount(FormFieldSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 单字段
     */
    FormFieldDto selectById(Long id);

    /**
     * 新增
     * @param dto 单字段
     * @return 执行结果
     */
    int insert(FormFieldDto dto);

    /**
     * 更新
     * @param dto 单字段
     * @return 执行结果
     */
    int update(FormFieldDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
