package cn.com.duiba.kjy.livecenter.api.remoteservice.liveconf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.conf.LiveConfSpecifyAwardDto;

import java.util.List;

/**
 * 直播代理人指定中奖配置rpc接口
 * @author 吴文哲
 * @date 2020-09-06 14:38
 **/
@AdvancedFeignClient
public interface RemoteLiveConfSpecifyAwardService {

    /**
     * 插入指定中奖配置
     *
     * @param awardDto 指定中奖对象
     * @return 主键
     */
    Long addSpecifyAwardConf(LiveConfSpecifyAwardDto awardDto);

    /**
     * 根据主键更新指定中奖配置
     *
     * @param awardDto 指定中奖对象
     * @return 影响行数
     */
    int updateSpecifyAwardConf(LiveConfSpecifyAwardDto awardDto);


    /**
     * 根据主键减少奖品库存
     * @param id 主键
     * @return 影响行数
     */
    int decreaseRemainingCount(Long id);

    /**
     * 根据主键查询
     *
     * @param id 主键id
     * @return 配置对象
     */
    LiveConfSpecifyAwardDto findById(Long id);

    /**
     * 根据主键删除
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

    /**
     * 根据直播间id 查询配置
     * @param liveId 直播间id
     * @return 配置对象
     */
    List<LiveConfSpecifyAwardDto> findByLiveId(Long liveId);

    /**
     * 根据主键id查询列表
     * @param ids 主键id列表
     * @return 对象列表
     */
    List<LiveConfSpecifyAwardDto> findByIds(List<Long> ids);
}
