package cn.com.duiba.kjy.livecenter.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.red.RedCollectDto;

import java.util.List;

/**
 * 直播红包-红包池子
 * @author dugq
 * @date 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteRedPondDataService {

    /**
     * 是否需要收集用户
     * @param liveId 直播ID
     * @return true-需要收集，false-不需要
     */
    boolean needCollect(Long liveId);

    /**
     * 收集用户信息
     * @param userList 用户信息
     */
    void collect(List<RedCollectDto> userList);
}
