package cn.com.duiba.kjy.livecenter.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author dugq
 * @date 2020-07-30 14:08
 */
@AdvancedFeignClient
public interface RemoteMoveAgentTeamService {

    /**
     * 矫正数据。
     * 代理人推出团队，导致邀请数据丢失。切直播未开始时，可进行邀请数据矫正
     * 直播已开始，无法修复
     *
     * @param agentId      需要矫正的人的代理人ID
     * @param sourceTeamId 该代理人原来的teamID
     * @param liveId       需要矫正的直播ID
     */
    boolean adjustAgentData(Long agentId, Long sourceTeamId, Long liveId);

    /**
     * 移动团队。
     * 代理人团队未发生变化的，不进行修改
     *
     * @param agentId
     * @param teamId
     */
    boolean updateAgentTeam(Long agentId, Long teamId);
}
