package cn.com.duiba.kjy.livecenter.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.statistics.LiveStatisticsDto;

import java.util.List;

/**
 * 直播统计rpc服务
 * @author 吴文哲
 * @date 2020-03-31 18:36
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsService {

    /**
     * 根据直播间id查找
     * @param liveId
     * @return
     */
    LiveStatisticsDto findByLiveId(Long liveId);

    /**
     * 根据直播间id列表 查询统计数据
     * @param liveIds
     * @return
     */
    List<LiveStatisticsDto> findByLiveIds(List<Long> liveIds);


    /**
     * 统计直播间数据
     * @param liveId
     * @return
     */
    Integer statisticLiveData(Long liveId);
}
