package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.bean.Page;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyConfDetailDto;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyDetailDto;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyDto;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyNameDto;
import cn.com.duiba.kjy.livecenter.api.param.CreateLiveMpQrCodeParam;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveCompanyClueCollectorParam;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveCompanySearchParam;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 直播公司服务
 * @author 周舟
 * @date 2020-3-28 10:22:23
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveCompanyService {

    /**
     * 分页查询
     * @param queryParam 分页查询参数
     * @return 直播公司集合
     */
    Page<LiveCompanyDto> findPageList(LiveCompanySearchParam queryParam);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播公司
     */
    LiveCompanyDto findById(Long id);

    /**
     * 根据主键查询详情（包含统计数据）
     * @param id 主键
     * @return 公司详情
     */
    LiveCompanyDetailDto findDetailById(Long id);

    /**
     * 保存更新直播公司
     * @param dto 直播公司
     * @return 主键，为0，说明新增失败
     */
    Long saveAndUpdate(LiveCompanyDto dto);

    /**
     * 新增或更新（包含配置）
     * @param detailDto 公司及配置信息
     * @return 主键，为null或0说明失败
     */
    Long saveAndUpdateDetail(LiveCompanyConfDetailDto detailDto);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 直播公司
     */
    Integer deleteById(Long id);

    /**
     * 批量查询
     * @param ids
     * @return
     */
    List<LiveCompanyDto> findByIds(List<Long> ids);

    /**
     * 根据公司id集合查询公司名称
     * @param ids 公司id集合
     * @return key：公司id value：公司名称
     */
    Map<Long, String> findCompanyNameByIds(List<Long> ids);

    /**
     * 保存直播公司线索收集员信息
     * @param param
     * @return
     */
    Boolean saveClueCollector4Kjj(LiveCompanyClueCollectorParam param);

    /**
     * 根据线索员id 查询公司列表
     * @param agentId
     * @return
     */
    List<LiveCompanyDto> findByClueCollectorId(Long agentId);

    /**
     * 获取生成小程序码的参数（管理员邀请队员）
     * @param companyId 公司ID
     * @return 生成小程序码的参数
     */
    CreateLiveMpQrCodeParam getMpQrCodeParam(Long companyId);

    /**
     * 更新公司的微信小程序二维码
     * @param companyId 公司ID
     * @param qrCodeUrl 二维码
     * @return 更新结果
     */
    Integer updateQrcodeUrl(Long companyId,String qrCodeUrl);

    /**
     * 更新直播试用账号到期时间
     *
     * @param id 主键id
     * @param authExpiryDate 直播试用账号到期时间
     * @return 更新结果
     */
    Integer updateAuthExpiryDate(Long id, Date authExpiryDate);

    /**
     * 根据公司名获取公司信息，最多返回1000条
     * @param companyName 公司名称
     * @return 公司名称信息
     */
    List<LiveCompanyNameDto> findByCompanyName(String companyName);

    /**
     * 获取公司logo
     * @param companyId 公司ID
     * @return 公司logo
     */
    String getCompanyLogo(Long companyId);

    /**
     * 获取logo，优先取线索员头像，没有取公司logo
     * @param companyId 公司id
     * @return logo
     */
    String getCluePosterLogo(Long companyId);
}
