package cn.com.duiba.kjy.livecenter.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * Created by dugq on 2020-07-02.
 */
@AdvancedFeignClient
public interface RemoteGrantLotteryCodeService {
    /**
     * 判断直播是否需要发放抽奖码
     * @param liveId
     * @return
     */
    boolean isLotteryActivityOpenWithLocalCache(Long liveId);

    /**
     * 批量发放签到抽奖码
     * @param liveId
     * @param liveUserIds
     */
    void batchInsertPresentLive(Long liveId, List<Long> liveUserIds);


    /**
     * 批量处理观看时长 发放抽奖码
     */
    void batchInsertWatchTime(Long liveId,List<Long> liveUserId);

}
