package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author xuzhigang
 * @date 2020/9/19 9:56 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveVisitorQrcodeService {
    /**
     * 根据liveId和visitorId查询小程序码
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码
     */
    String getMpQrcodeUrl(Long liveId, Long visitorId);

    /**
     * 获取访客小程序码 缓存10min
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码
     */
    String getMpQrcodeUrlCache(Long liveId, Long visitorId);

    /**
     * 给访客绑定一个小程序码，并返回小程序码
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @param scene 小程序码参数
     * @return 返回小程序码
     * @deprecated 已废弃 下版本删除
     */
    @Deprecated
    String bindMpQrcode(Long liveId, Long visitorId, String scene);

    /**
     * 绑定小程序码降级方案
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @param scene 小程序码参数
     * @return 返回小程序码
     * @deprecated 已废弃 下版本删除
     */
    @Deprecated
    String bindMpQrcodeDegrade(Long liveId, Long visitorId, String scene);

    /**
     * 绑定生成的小程序码
     *
     * @param qrcodeId  小程序码id
     * @param liveId    直播id
     * @param visitorId 访客id
     * @return 小程序码url
     */
     boolean bindMpQrcodeByQrcdeId(Long qrcodeId, Long liveId, Long visitorId);
}
