/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.util;

import cn.com.duiba.kjy.livecenter.api.dto.share.AgentShareApiBean;
import cn.com.duiba.kjy.livecenter.api.dto.share.LiveRoomShareApiBean;
import cn.com.duiba.kjy.livecenter.api.dto.share.ShareApiBean;
import cn.com.duiba.kjy.livecenter.api.enums.live.share.ShareTypeApiEnum;
import cn.com.duiba.wolf.utils.BlowfishUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ApiShareUtils {
    private static final String SHARE_ENCRYPT = "89f1657ff6a3";

    private ApiShareUtils() {
    }

    public static <T extends ShareApiBean> String signShareBean(T bean) {
        if (Objects.isNull(bean)) {
            return null;
        }
        ShareTypeApiEnum shareTypeEnum = ShareTypeApiEnum.getByCode(bean.getShareType());
        if (shareTypeEnum == null) {
            return null;
        }
        try {
            return BlowfishUtils.encryptBlowfish((String)JSON.toJSONString(bean), (String)SHARE_ENCRYPT);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T extends ShareApiBean> T decodeShareSign(String sign, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)sign) || "undefined".equals(sign) || StringUtils.equals((CharSequence)sign, (CharSequence)"null")) {
            return null;
        }
        try {
            String content = BlowfishUtils.decryptBlowfish((String)sign, (String)SHARE_ENCRYPT);
            JSONObject jsonObject = JSON.parseObject((String)content);
            ShareApiBean bean = (ShareApiBean)jsonObject.toJavaObject(clazz);
            if (bean == null) {
                return null;
            }
            ShareTypeApiEnum shareTypeEnum = ShareTypeApiEnum.getByCode(bean.getShareType());
            if (shareTypeEnum == null) {
                return null;
            }
            if (!shareTypeEnum.getCode().equals(jsonObject.getInteger("shareType"))) {
                return null;
            }
            return (T)bean;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void main(String[] args) {
        LiveRoomShareApiBean r = ApiShareUtils.decodeShareSign("Cwshma2hqnpG4ENdTzikiYsrxbAAUB4wTKJk64mUZmukVgJQKyujZJHkdA8gYqFApE4eECvSWFrnqZXVhyofmNQb9z8RWCurtBqbEh3n7gF4D7R", LiveRoomShareApiBean.class);
        AgentShareApiBean r1 = ApiShareUtils.decodeShareSign("Cwshma2hqnpG4ENdTzikiYsrxbAAUB4wTKJk64mUZmukVgJQKyujZJHkdA8gYqFApE4eECvSWFrnqZXVhyofmNQb9z8RWCurtBqbEh3n7gF4D7R", AgentShareApiBean.class);
        System.out.println(r);
        System.out.println(r1);
    }
}

