package cn.com.duiba.kjy.livecenter.api.dto;

import com.google.common.collect.Lists;
import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Created by dugq on 2019-02-13.
 */
@Data
public class CenterPageResult<T extends Serializable> implements Serializable {
    private static final long serialVersionUID = 5033472050991731743L;
    private Integer pageIndex;
    private Integer pageSize;
    /**
     * 除非前端页面需要展示总数，否者不要count！！！！
     */
    private Long totalCount;
    private List<T> list;
    private Boolean hasNext;


    public Boolean getHasNext() {
        if(Objects.isNull(hasNext)){
            Long totalPage = getTotalPage();
            if(Objects.nonNull(totalPage)){
                return totalPage - pageIndex > 0;
            }
        }
        return hasNext;
    }

    public Long getTotalPage(){
        if(Objects.nonNull(pageIndex) && Objects.nonNull(totalCount) && Objects.nonNull(pageSize)){
            return totalCount / pageSize + (totalCount % pageSize > 0 ? 1 : 0);
        }
        return null;
    }

    public static CenterPageResult init(Integer pageIndex, Integer pageSize) {
        CenterPageResult pageResult = new CenterPageResult();
        pageResult.setList(Lists.newArrayList());
        pageResult.setTotalCount(0L);
        pageResult.setPageIndex(pageIndex);
        pageResult.setPageSize(pageSize);
        return pageResult;
    }

    public static <T extends Serializable> CenterPageResult<T> emptyPageResult() {
        CenterPageResult<T> pageList = new CenterPageResult<>();
        pageList.setList(new ArrayList<>());
        return pageList;
    }


}
