package cn.com.duiba.kjy.livecenter.api.enums;

/**
 * 内部日志类型
 * @author lizhi
 * @date 2020/4/20 6:01 PM
 */
public enum InnerLogTypeEnum {
    SHARE(1,"分享"),
    ONLINE(2,"在线人数"),
    ENTER(3,"进入直播"),
    OUT(4,"退出直播"),
    SPOKE_LIMITER(5,"评论限流"),
    PUBLIC_LIMITER(6,"公共推送限流"),
    LUCK_TASK(7, "幸运任务"),
    DRAW_TASK(8, "中奖任务"),
    QUESTION_RED_SHARE(9, "答题红包,答错用户分享直播间复活"),
    USER_QUESTION_RED_ANSWER_RESULT(10, "答题红包,用户答题信息"),
    EVENT_TIME(11, "直播事件时间记录"),
    ;

    private Integer type;

    private String desc;

    InnerLogTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
