package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.company.LiveAgentDto;
import cn.com.duiba.kjy.livecenter.api.param.common.ApiPage;
import cn.com.duiba.kjy.livecenter.api.param.company.LiveAgentSearchParam;

/**
 * 直播代理人服务
 * @author 周舟
 * @date 2020-3-28 10:22:31
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteAgentService {


    /**
     * 列表查询
     * @param queryParam 查询参数
     * @return 直播代理人集合
     */
    ApiPage<LiveAgentDto> findPageV2(LiveAgentSearchParam queryParam);

    /**
     * 代理人加入团队
     * @param dto 直播代理人
     * @return 主键，为0，说明新增失败
     */
    Long join(LiveAgentDto dto);

    /**
     * 根据id查询
     * @param id 主键id
     * @return 直播代理人
     */
    LiveAgentDto findById(Long id);

    /**
     * 根据id删除
     * @param id 主键id
     * @return 是否成功 1 成功 其他失败
     */
    Integer deleteById(Long id);

}
