package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveUserFeedbackDto;
import cn.com.duiba.kjy.livecenter.api.param.live.LiveUserFeedbackSearchParam;

import java.util.List;

/**
 * 用户意见反馈rpc服务
 *
 * @author xuzhigang
 * @date 2020-10-15
 */
@AdvancedFeignClient
public interface RemoteLiveUserFeedbackService {
     
    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 用户意见反馈集合
     */
    List<LiveUserFeedbackDto> selectListPage(LiveUserFeedbackSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveUserFeedbackSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 用户意见反馈
     */
    LiveUserFeedbackDto selectById(Long id);

    /**
     * 新增
     * @param dto 用户意见反馈
     * @return 执行结果
     */
    int insert(LiveUserFeedbackDto dto);

    /**
     * 更新
     * @param dto 用户意见反馈
     * @return 执行结果
     */
    int update(LiveUserFeedbackDto dto);

    /**
     * 软删
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}