package cn.com.duiba.kjy.livecenter.api.util;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by dugq on 2019-03-23.
 *
 */
public class FormatUtils {

    private static final String REGEX_1 = "\\{\\{.*?\\}\\}";
    private static final String REGEX_2 = "\\{.*?\\}";

    private FormatUtils(){}

    /**
     * 占位符填充。 如果params中不含占位符参数，占位符会被抹掉。
     * 支持占位符格式： {{key}}
     *[n] 换行符
     * [s] 空格
     * @param template 原文字符串
     * @param params 占位符属性名称和value的键值对
     * @return 替换后的占位符
     */
    public static String formatDoubleBrace(String template, Map<String,Object> params){
        return doFormat(template, params, REGEX_1,false);
    }

    /**
     * 占位符填充。 如果params中不含占位符参数，占位符会被抹掉。
     * 支持占位符格式： {key}
     *[n] 换行符
     * [s] 空格
     * @param template 原文字符串
     * @param params 占位符属性名称和value的键值对
     * @return 替换后的占位符
     */
    public static String formatBrace(String template, Map<String,Object> params){
        return doFormat(template, params, REGEX_2,false);
    }

    /**
     * 占位符填充
     * @param template 原文字符串
     * @param params 占位符属性名称和value的键值对
     * @param regex1 占位符 格式
     * @param skip 是否保留params中不存在的key的占位符 true 保留 false 删除
     * @return
     */
    private static String doFormat(String template, Map<String, Object> params, String regex1,boolean skip) {
        if(MapUtils.isEmpty(params)){
            params = new HashMap<>();
        }
        if(StringUtils.isBlank(template)){
            return template;
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = Pattern.compile(regex1).matcher(template);
        while (m.find()) {
            String param = m.group();
            Object value = params.get(param.substring(2, param.length() - 2));
            if (Objects.isNull(value) && skip){ // 跳过params中不存在的占位符 保留原样
                continue;
            }
            m.appendReplacement(sb, value==null ? "" : Matcher.quoteReplacement(value.toString()));
        }
        m.appendTail(sb);
        String message = sb.toString();
        message = message.replaceAll("\\[n\\]","\n");
        message = message.replaceAll("\\[s\\]"," ");
        return message;
    }


    /**
     * 把 a:1,b:2 的字符串转为： {a:1;b:2}的map
     * @param source
     * @return
     */
    public static Map<String,String> formatString2Map(String source){
        Map<String,String> map = new HashMap<>();
        for (String oaIDPic: source.split(",")){
            if(oaIDPic.contains(":")){
                String[] split = oaIDPic.split(":");
                map.put(split[0],split[1]);
            }
        }
        return map;
    }

}
