package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author xuzhigang
 * @date 2020/9/19 9:56 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveVisitorQrcodeService {
    /**
     * 根据liveId和visitorId查询小程序码
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码
     */
    String getMpQrcodeUrl(Long liveId, Long visitorId);

    /**
     * 获取访客小程序码 缓存10min
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码
     */
    String getMpQrcodeUrlCache(Long liveId, Long visitorId);

    /**
     * 绑定生成的小程序码
     *
     * @param qrcodeId  小程序码id
     * @param liveId    直播id
     * @param visitorId 访客id
     * @return 小程序码url
     */
     boolean bindMpQrcodeByQrcdeId(Long qrcodeId, Long liveId, Long visitorId);
}
