package cn.com.duiba.kjy.livecenter.api.dto.importtask;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 导入任务表
 * @author kjj mybatis generator 
 * @date 2020-10-21
 */
@Data
public class LiveImportTaskDto implements Serializable {
     
    private static final long serialVersionUID = 16032594997292050L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 任务类型 1-上传架构名单 2-删除架构名单 3-业务员列表-批量删除权限 4-业务员列表-批量切换团队 5-业务员列表-批量更新信息
     * @see cn.com.duiba.kjy.livecenter.api.enums.importtask.LiveImportTaskTypeEnum
     */
    private Integer taskType;

    /**
     * 文件名称
     */
    private String fileName;

    /**
     * 公司id 没有公司id默认为0
     */
    private Long companyId;

    /**
     * 导入总数
     */
    private Integer importCount;

    /**
     * 导入失败数量
     */
    private Integer failureCount;

    /**
     * 导入成功数量
     */
    private Integer successCount;

    /**
     * 任务状态 0-初始化 1-导入中 2-导入失败(系统报错) 3-导入完成
     * @see cn.com.duiba.kjy.livecenter.api.enums.importtask.LiveImportTaskStatusEnum
     */
    private Integer taskStatus;

    /**
     * 导入源文件
     */
    private String importExcelUrl;

    /**
     * 导入失败文件
     */
    private String failureExcelUrl;

    /**
     * 上传时间
     */
    private Date gmtCreate;

}