package cn.com.duiba.kjy.livecenter.api.dto.share;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播分享配置
 * @author kjj mybatis generator 
 * @date 2020-08-08
 */
@Data
public class LiveShareConfDto implements Serializable {
     
    private static final long serialVersionUID = 15968703368398605L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID，对应tb_live.id
     */
    private Long liveId;

    /**
     * 小程序分享图
     */
    private String mpShareUrl;

    /**
     * 小程序分享标题
     */
    private String mpShareTitle;

    /**
     * 分享类型：1-普通小程序分享，2-手气王小程序分享
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.share.LiveShareTypeEnum
     */
    private Integer shareType;

    /**
     * 是否已删除：0-未删除，1-已删除
     * @see cn.com.duiba.kjy.livecenter.api.enums.DeletedEnum
     */
    private Integer deleted;
}