package cn.com.duiba.kjy.livecenter.api.remoteservice.wspush;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.wspush.WsShareDto;

import java.util.List;

/**
 * 用户分享直播间消息推送队列
 * @author dugq
 * @date 2020-07-01
 */
@AdvancedFeignClient
public interface RemoteUserShareService {

    /**
     * 追加用户
     * @param liveId 直播ID
     * @param dto 推送的消息
     */
    void addUser(Long liveId, WsShareDto dto);

    /**
     * 获取最近1s分享用户
     * @param liveId 直播ID
     * @return 分享用户集合集合
     */
    List<WsShareDto> getRecentlyUser(Long liveId);
}
