package cn.com.duiba.kjy.livecenter.api.enums.guide;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 引导视频类型
 * @author lizhi
 * @date 2020/11/17 11:57 上午
 */
@Getter
@AllArgsConstructor
public enum GuideVideoTypeEnum {

    BASIC_COURSE(1, "基础教程"),
    ADVANCED_COURSE(2, "高级教程"),
    ;

    private final Integer type;

    private final String desc;

    private static final Map<Integer, GuideVideoTypeEnum> ENUM_MAP = new HashMap<>();

    static {
        for (GuideVideoTypeEnum typeEnum : values()) {
            ENUM_MAP.put(typeEnum.type, typeEnum);
        }
    }

    public static GuideVideoTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
