package cn.com.duiba.kjy.livecenter.api.enums.qrcode;

import java.util.Objects;

/**
 * 二维码场景枚举类
 *
 * @author 吴文哲
 * @date 2020-04-10 15:23
 **/
public enum LiveQrcodeTypeEnum {

    LIVE_ADMIN_TEAM_INVITE(1, "直播管理员,团队列表页,邀请代理人加入团队"),
    LIVE_ADMIN_LIVE_LIST_SHARE(2, "直播管理员,直播列表分享"),
    LIVE_AGENT_INVITE_USER_SHARE(3, "直播代理人,邀请访客观看直播"),
    ;

    public static LiveQrcodeTypeEnum getByType(Integer type) {
        for (LiveQrcodeTypeEnum typeEnum : LiveQrcodeTypeEnum.values()) {
            if (Objects.equals(typeEnum.getType(), type)) {
                return typeEnum;
            }
        }
        return null;
    }

    /**
     * 场景类型
     */
    private Integer type;


    /**
     * 描述
     */
    private String decs;

    LiveQrcodeTypeEnum(Integer type, String desc) {
        this.type = type;
        this.decs = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDecs() {
        return decs;
    }

}
