package cn.com.duiba.kjy.livecenter.api.remoteservice.common;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.common.CommonQuestionDto;
import cn.com.duiba.kjy.livecenter.api.dto.common.CommonQuestionOptionDto;

import java.util.List;
import java.util.Set;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/10/17 11:07
 */
@AdvancedFeignClient
public interface RemoteCommonQuestionService {

    /**
     * 根据业务id和业务类型查询
     * @param bizIds 业务id集合
     * @param bizType 业务类型
     * @return 问题配置信息
     */
    List<CommonQuestionDto> findByBizIdsAndType(Set<Long> bizIds, Integer bizType);

    /**
     * 根据业务id和业务类型查询
     * @param bizId 业务id
     * @param bizType 业务类型 {@link cn.com.duiba.kjy.livecenter.api.enums.common.CommonQuestionBizTypeEnum}
     * @return
     */
    CommonQuestionDto findByBizAndType(Long bizId, Integer bizType);

    /**
     * 根据问题id查询
     * @param quesId 问题id
     * @return 问题选项
     */
    List<CommonQuestionOptionDto> findOptionByQuesId(Long quesId);

}
