package cn.com.duiba.kjy.livecenter.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.statistics.LiveStatisticsAgentDto;
import cn.com.duiba.kjy.livecenter.api.dto.statistics.LiveStatisticsAgentSimpleDto;
import cn.com.duiba.kjy.livecenter.api.param.statistics.LiveStatisticsAgentSearchParam;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;

/**
 * 代理人纬度直播统计rpc服务
 * @author 吴文哲
 * @date 2020-03-30 15:51
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsAgentService {

    /**
     * 根据直播间id 代理人id 获取统计数据
     * @param liveId  直播间id
     * @param agentId 代理人id
     * @return
     */
    LiveStatisticsAgentDto getByLiveIdAndAgentId(Long liveId,Long agentId);

    /**
     * 根据条件获取对应直播间 代理人纬度统计数据
     * @param param
     * @return
     */
    List<LiveStatisticsAgentDto> getListByCondition(LiveStatisticsAgentSearchParam param);

    /**
     * 获取代理人排名
     * 不同直播间状态 统计数据不同
     * @param liveId 直播间id
     * @param agentId 代理人id
     * @return
     */
    Integer getAgentRanking(Long liveId,Long agentId);

    /**
     * 获取直播间id 对应代理人排名map
     * @param liveIds
     * @param agentId
     * @return
     */
    Map<Long,Integer> getAgentRankingByLiveIds(List<Long> liveIds, Long agentId);

    /**
     * 获取代理人队内排名
     * 不同直播间状态 统计数据不同
     *
     * @param liveId 直播id
     * @param agentId 代理人id
     * @return 队内排名
     */
    Integer getAgentTeamRanking(Long liveId, Long agentId);

    /**
     * 根据条件统计
     * @param liveId 直播间id
     * @param companyId 公司id
     * @return left:邀请数量 right:到场数量
     */
    Pair<Integer,Integer> getCompanyInviteAndPresentSum(Long liveId, Long companyId);

    /**
     * 读取线索数量+1
     *
     * @param liveId 直播id
     * @param agentId 代理人id
     * @return 执行结果
     */
    int increaseReadNum(Long liveId, Long agentId);

    /**
     * 根据直播IDs 和 代理人ID查询
     * @param agentId 代理人ID
     * @param liveIds 直播IDs
     * @return 代理人统计数据
     */
    List<LiveStatisticsAgentSimpleDto> selectByAgentIdAndLiveIds(Long agentId, List<Long> liveIds);

    /**
     * 根据直播ID 和 代理人IDs查询
     * @param liveId 直播ID
     * @param agentIds 代理ids
     * @return 代理人统计数据
     */
    List<LiveStatisticsAgentSimpleDto> selectByLiveIdAndAgentIds(Long liveId, List<Long> agentIds);
}
