package cn.com.duiba.kjy.livecenter.api.dto.advice;

import lombok.Data;

import java.io.Serializable;

/**
 * 聊天室-每个类型所有消息ID
 * @author lizhi
 * @date 2020/7/2 9:13 PM
 */
@Data
public class LiveAdviceUnReadDto implements Serializable {

    private static final long serialVersionUID = 8457408315148081891L;

    /**
     * 聊天室唯一标识，由live_id、live_agent_id、live_visitor_id下划线组成字符串的MD5
     */
    private String sessionKey;

    /**
     * 回复类型 0：访客回复 1：代理人回复 2:代理人自动回复
     * @see cn.com.duiba.kjy.livecenter.api.enums.advice.AdviceChatTypeEnum
     */
    private Integer chatType;

    /**
     * 主键，以英文逗号分隔
     */
    private String ids;
}
