package cn.com.duiba.kjy.livecenter.api.dto.share;

import cn.com.duiba.kjy.livecenter.api.enums.live.share.ShareTypeApiEnum;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 代理人分享直播参数
 * @author lizhi
 * @date 2020/4/12 11:46 AM
 */
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class AgentShareApiBean extends ShareApiBean {

    private static final long serialVersionUID = 5316818261607587674L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 代理人的userID
     */
    private Long sharedUserId;

    /**
     * 代理人ID
     */
    private Long agentId;

    public AgentShareApiBean() {
        super(ShareTypeApiEnum.VISITOR_MP_SELLER_INVITATION.getCode());
    }
}
