package cn.com.duiba.kjy.livecenter.api.enums.importtask;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 导入任务状态枚举
 *
 * @author xuzhigang
 * @date 2020/10/21 2:11 下午
 **/
@Getter
@AllArgsConstructor
public enum LiveImportTaskStatusEnum {
    INIT(0, "初始化"),

    IMPORTING(1, "导入中"),

    IMPORT_FAILURE(2, "导入失败"),

    IMPORT_SUCCESS(3, "导入成功"),
    ;

    /**
     * 导入状态
     */
    private Integer status;

    /**
     * 描述
     */
    private String desc;
}
