package cn.com.duiba.kjy.livecenter.api.remoteservice.activate;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.activate.LiveAgentImportTaskDto;
import cn.com.duiba.kjy.livecenter.api.param.activate.LiveAgentImportTaskSearchParam;

import java.util.List;

/**
 * 直播代理人导入任务服务rpc接口
 * @author 吴文哲
 * @date 2020-08-28 16:01
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentImportTaskService {

    /**
     * 根据条件查询任务列表
     * @return
     */
    List<LiveAgentImportTaskDto> getImportTaskByCondition(LiveAgentImportTaskSearchParam searchParam);

    /**
     * 根据条件统计
     * @param searchParam 查询参数
     * @return 统计总数
     */
    long countImportByCondition(LiveAgentImportTaskSearchParam searchParam);

    /**
     * 新增任务记录
     * @param taskEntity 任务记录
     * @return 主键
     */
    Long addImportTask(LiveAgentImportTaskDto taskEntity);

    /**
     * 叠加总数
     * @param id 主键
     * @param totalCount 总数
     * @return 增加行数
     */
    int increaseTotalCount(Long id,Integer totalCount);

    /**
     * 叠加成功总数
     * @param id 主键
     * @param successCount 成功数
     * @return 影响行数
     */
    int increaseSuccessCount(Long id,Integer successCount);

    /**
     * 叠加失败总数
     * @param id 主键
     * @param failureCount 失败数
     * @return
     */
    int increaseFailureCount(Long id,Integer failureCount);

    /**
     * 根据之间查找
     * @param id 主键
     * @return
     */
    LiveAgentImportTaskDto findById(Long id);

    /**
     * 任务状态
     * @param taskStatus 任务状态
     * @see cn.com.duiba.kjy.livecenter.api.enums.advice.AgentImportTaskEnum
     * @return 是否更新成功
     */
    boolean updateStatus(Long id,Integer taskStatus);
}
