package cn.com.duiba.kjy.livecenter.api.remoteservice.link;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.link.LiveSpreadLinkDto;
import cn.com.duiba.kjy.livecenter.api.param.link.LiveSpreadLinkSearchParam;

import java.util.List;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020-08-05 16:56
 */
@AdvancedFeignClient
public interface RemoteLiveSpreadLinkService {


    /**
     * 根据条件查询，分页
     * @param param 查询条件
     * @return 直播推广链接集合
     */
    List<LiveSpreadLinkDto> selectPage(LiveSpreadLinkSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(LiveSpreadLinkSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播推广链接
     */
    LiveSpreadLinkDto selectById(Long id);

    /**
     * 新增
     * @param dto 直播推广链接
     * @return 执行结果
     */
    Long insert(LiveSpreadLinkDto dto);

    /**
     * 更新
     * @param dto 直播推广链接
     * @return 执行结果
     */
    int update(LiveSpreadLinkDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    int delete(Long id);
}
