package cn.com.duiba.kjy.livecenter.api.remoteservice.wspush;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.wspush.WsResultDto;

import java.util.List;

/**
 * 直播间左侧评论区上方公共推送，每秒所有类型最多推送10个
 * @author lizhi
 * @date 2020/11/3 1:45 下午
 */
@AdvancedFeignClient
public interface RemotePushAllInLeftAreaService {

    /**
     * 往队列中添加需要推送给全部用户的推送
     * @param liveId 直播ID
     * @param msgType 推送的消息类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.WsMsgTypeEnum
     * @param pushList 序列化成json字符串的 推送信息对象集合，
     *                 上游业务需要聚合处理，避免rpc交互过高
     *                 示例：List<WsComingVo> voList;
     *                      JSON.toJSONString(list);
     * @see cn.com.duiba.kjy.livecenter.api.util.CommonPushUtils
     */
    void addPushAll(Long liveId, int msgType, String pushList);

    /**
     * 获取最近1s内需要给全部用户推送的消息
     * @param liveId 直播ID
     * @return 由于redis【通用队列】中的数据类型不一致，为解决反序列话的问题，data都为String
     */
    List<WsResultDto<String>> getRecentlyPushAll(Long liveId);
}
