/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.livecenter.api.util;

import cn.com.duiba.kjy.livecenter.api.dto.company.LiveCompanyDto;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveCompanyLevelUtil {
    private static final Logger log = LoggerFactory.getLogger(LiveCompanyLevelUtil.class);

    private LiveCompanyLevelUtil() {
    }

    @Nullable
    public static LiveCompanyDto getLowerLevelLiveCompanyDto(List<LiveCompanyDto> companyDtoList) {
        if (CollectionUtils.isEmpty(companyDtoList)) {
            return null;
        }
        if (companyDtoList.size() == 1) {
            return companyDtoList.get(0);
        }
        List<LiveCompanyDto> list = LiveCompanyLevelUtil.sortByLevel(companyDtoList);
        return LiveCompanyLevelUtil.getLast(list);
    }

    public static boolean hasDistinctLevel(List<LiveCompanyDto> companyDtoList) {
        if (CollectionUtils.isEmpty(companyDtoList)) {
            return false;
        }
        HashSet<Integer> levelSet = new HashSet<Integer>();
        for (LiveCompanyDto companyDto : companyDtoList) {
            if (levelSet.add(companyDto.getCompanyLevel())) continue;
            return true;
        }
        return false;
    }

    public static LiveCompanyDto getDistinctLevelCompany(List<LiveCompanyDto> companyDtoList, @NonNull LiveCompanyDto liveCompanyDto) {
        if (CollectionUtils.isEmpty(companyDtoList)) {
            return null;
        }
        HashSet<Integer> levelSet = new HashSet<Integer>();
        levelSet.add(liveCompanyDto.getCompanyLevel());
        for (LiveCompanyDto companyDto : companyDtoList) {
            if (levelSet.add(companyDto.getCompanyLevel())) continue;
            return companyDto;
        }
        return null;
    }

    public static boolean isLineCompany(List<LiveCompanyDto> companyDtoList) {
        if (CollectionUtils.isEmpty(companyDtoList)) {
            return false;
        }
        if (companyDtoList.size() == 1) {
            return true;
        }
        if (LiveCompanyLevelUtil.hasDistinctLevel(companyDtoList)) {
            return false;
        }
        LiveCompanyDto lowerLevelCompany = LiveCompanyLevelUtil.getLowerLevelLiveCompanyDto(companyDtoList);
        if (lowerLevelCompany == null) {
            return false;
        }
        String higherIds = lowerLevelCompany.getHigherIds();
        if (StringUtils.isBlank((CharSequence)higherIds)) {
            return false;
        }
        String[] higherIdStr = higherIds.split(",");
        List higherIdList = Arrays.stream(higherIdStr).map(Long::parseLong).collect(Collectors.toList());
        for (LiveCompanyDto liveCompanyDto : companyDtoList) {
            if (Objects.equals(liveCompanyDto.getId(), lowerLevelCompany.getId()) || higherIdList.contains(liveCompanyDto.getId())) continue;
            return false;
        }
        return true;
    }

    public static <T> T getLast(List<T> list) {
        if (CollectionUtils.isEmpty(list)) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    public static List<LiveCompanyDto> sortByLevel(List<LiveCompanyDto> companyDtoList) {
        if (CollectionUtils.isEmpty(companyDtoList)) {
            return companyDtoList;
        }
        return companyDtoList.stream().sorted(Comparator.comparing(LiveCompanyDto::getCompanyLevel)).collect(Collectors.toList());
    }

    public static LiveCompanyDto getSameLevelCompany(List<LiveCompanyDto> companyDtoList, LiveCompanyDto companyDto) {
        Map<Integer, List<LiveCompanyDto>> levelMap = companyDtoList.stream().collect(Collectors.groupingBy(LiveCompanyDto::getCompanyLevel));
        List<LiveCompanyDto> liveCompanyDtoList = levelMap.get(companyDto.getCompanyLevel());
        if (CollectionUtils.isEmpty(liveCompanyDtoList)) {
            return null;
        }
        if (liveCompanyDtoList.size() > 1) {
            log.error("liveActivate, has save level company");
        }
        return liveCompanyDtoList.get(0);
    }
}

