package cn.com.duiba.kjy.livecenter.api.remoteservice.statistics;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.statistics.LiveStatisticsAgentExtDto;

import java.util.List;

/**
 * 直播统计-代理人维度线索统计扩展相关服务
 *
 * @author xuzhigang
 * @date 2020/12/3 6:32 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveStatisticsAgentExtService {
    /**
     * 批量查询
     *
     * @param liveId 直播id
     * @param agentIds 代理人id集合
     * @param actionTypes 行为集合 {@link cn.com.duiba.kjy.livecenter.api.enums.clue.LiveVisitorActionEnums}
     * @return 线索集合
     */
    List<LiveStatisticsAgentExtDto> selectListByAgentIdsAndActionTypes(Long liveId, List<Long> agentIds, List<Integer> actionTypes);

}
