package cn.com.duiba.kjy.livecenter.api.enums.guide;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;

/**
 * 引导视频-观看状态
 * @author lizhi
 * @date 2020/11/17 11:57 上午
 */
@Getter
@AllArgsConstructor
public enum GuideWatchStatusEnum {
    NON_WATCH(1, "未观看"),
    WATCHING(2, "观看中"),
    WATCHED(3, "已看完"),
    ;

    private final Integer status;

    private final String desc;

    private static final Map<Integer, GuideWatchStatusEnum> ENUM_MAP = new HashMap<>();

    static {
        for (GuideWatchStatusEnum statusEnum : values()) {
            ENUM_MAP.put(statusEnum.status, statusEnum);
        }
    }

    public static GuideWatchStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }
}
