package cn.com.duiba.kjy.livecenter.api.remoteservice.liveclue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.param.liveclue.LiveClueTemplateSaveParam;

/**
 * 直播线索模板rpc服务
 * @author 吴文哲
 * @date 2020-04-13 14:46
 **/
@AdvancedFeignClient
public interface RemoteLiveClueTemplateService {

    /**
     * 新增线索模板
     * @param saveParam
     * @return
     */
    Integer addTemplate(LiveClueTemplateSaveParam saveParam);

    /**
     * 新增 直播线索模板
     * @param saveParam 直播线索模板参数
     * @return 新增结果
     */
    int addTemplateNew(LiveClueTemplateSaveParam saveParam);

    /**
     * 直播间绑定线索模板
     * @param templateId
     * @param liveId
     * @return
     */
    Integer liveBindTemplate(Long templateId,Long liveId);

    /**
     * 模板id
     * @param templateId
     * @return
     */
    Integer deleteTemplate(Long templateId);

}
