package cn.com.duiba.kjy.livecenter.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.lottery.LiveWinnerInfoDto;

import java.util.List;

/**
 * 直播中奖信息接口
 * @author 吴文哲
 * @date 2020/12/24 3:41 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveWinnerInfoService {

    /**
     * 新增中奖信息记录
     * @param dto 中奖信息记录
     * @return 影响行数
     */
    int save(LiveWinnerInfoDto dto);

    /**
     * 根据抽奖码id 查询中奖信息
     * @param codeId 抽奖码id
     * @return 直播中奖信息
     */
    LiveWinnerInfoDto findByLotteryCodeId(Long codeId);

    /**
     * 根据抽奖码ids 查询中奖信息列表
     * @param codeIds 抽奖码id
     * @return 直播中奖信息
     */
    List<LiveWinnerInfoDto> findByLotteryCodeIds(List<Long> codeIds);
}
