package cn.com.duiba.kjy.livecenter.api.enums.live;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 反馈页面枚举
 *
 * @author xuzhigang
 * @date 2020/10/15 2:29 下午
 **/
@Getter
@AllArgsConstructor
public enum FeedbackSourceEnum {
    NOTICE_PAGE(1, "预告页"),

    LIVE_PAGE(2, "直播页"),

    HOME(3, "首页"),

    COMPANY(4, "公司主页"),

    MY_WELFARE(5, "我的福利"),

    WELFARE_DETAIL(6, "福利/资料详情页"),

    SHORT_VIDEO(8, "视频页"),
    ;
    /**
     * 枚举值
     */
    private Integer code;

    /**
     * 描述
     */
    private String desc;
}
