package cn.com.duiba.kjy.livecenter.api.enums.live.share;

import java.util.Objects;

/**
 * 分享加密类型
 * @author lizhi
 * @date 2020/4/12 11:40 AM
 */
public enum ShareTypeApiEnum {

    VISITOR_MP_SELLER_INVITATION(1,"访客端小程序-代理人分享直播"),
    VISITOR_MP_LIVE_ROOM_INVITATION(2,"访客端小程序-直播间分享直播"),
    ;
    private Integer code;
    private String desc;

    ShareTypeApiEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 根据类型值查询枚举
     * @param shareType 分享加密类型
     * @return 枚举
     */
    public static ShareTypeApiEnum getByCode(Integer shareType){
        for (ShareTypeApiEnum typeEnum : ShareTypeApiEnum.values()){
            if(Objects.equals(shareType,typeEnum.getCode())){
                return typeEnum;
            }
        }
        return null;
    }
}
