package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.LiveAgentInvitationBizDto;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.LiveAgentInvitationDto;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.LiveAgentInvitationSimpleDto;
import cn.com.duiba.kjy.livecenter.api.dto.invitation.LiveVisitorInvitationDto;
import cn.com.duiba.kjy.livecenter.api.param.invitation.BatchCreateNewAgentInvitationParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.BatchCreateNewVisitorInvitationParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.CreateNewAgentInvitationParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.CreateNewVisitorInvitationParam;
import cn.com.duiba.kjy.livecenter.api.param.invitation.LiveAgentInvitationSearchParam;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 邀请客户服务类
 * @author 吴文哲
 * @date 2020-03-30 19:52
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentInvitationService {

    /**
     * 获取被邀请人的列表
     * @param param
     * @return
     */
    List<LiveAgentInvitationDto> getInvitedUserList(LiveAgentInvitationSearchParam param);

    /**
     * 统计被邀请人数
     * @param param
     * @return
     */
    Integer countInvitedUser(LiveAgentInvitationSearchParam param);

    /**
     * 查询被邀请人代理人ID
     * @param liveId 直播ID
     * @param visitorId 被邀请人用户ID
     * @return 被邀请人代理人ID
     */
    Long findAgentByLiveAndVisitorId(Long liveId, Long visitorId);

    /**
     * 批量查询绑定代理人信息
     * @param liveId 直播ID
     * @param visitorIdList 被邀请人用户ID集合
     * @return 绑定代理人信息
     */
    List<LiveAgentInvitationSimpleDto> findAgentsByLiveAndVisitorIds(Long liveId, List<Long> visitorIdList);

    /**
     * 查询被邀请人代理人ID
     * @param liveId 直播ID
     * @param bizUserId 被邀请人业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.BizTypeApiEnum
     * @return 邀请关系
     */
    LiveAgentInvitationBizDto findAgentByLiveAndBizUserIdAnType(Long liveId, String bizUserId, Integer bizType);

    /**
     * 新增绑定关系
     * @param param 参数
     * @return >0 绑定成功条数。正常 为1
     *
     */
    int insertAgentInvitation(CreateNewAgentInvitationParam param);

    /**
     * 新增访客邀请关系
     * @param param 访客信息
     * @return >0 绑定成功条数。正常 为1
     */
    int insertVisitorInvitation(CreateNewVisitorInvitationParam param);

    /**
     * 批量新增代理人邀请过绑定关系
     * @deprecated  为应对后续的业务，此接口升级,请使用{@link #batchInsertAgentInvitationAndGetInvitation}
     * @param params 搭理人列表
     * @param liveId 直播ID
     * @return 新增数量
     */
    @Deprecated
    int batchInsertAgentInvitation(List<BatchCreateNewAgentInvitationParam> params,Long liveId);

    /**
     *  批量新增代理人邀请绑定关系 并返回添加成功的邀请关系
     *  {@link #batchInsertAgentInvitation} 的升级版本
     * @param params
     * @param liveId
     * @return
     */
    List<LiveAgentInvitationDto> batchInsertAgentInvitationAndGetInvitation(List<BatchCreateNewAgentInvitationParam> params, Long liveId);

    /**
     * 批量新增访客邀请绑定关系
     * @deprecated  为应对后续的业务，此接口升级,请使用{@link #batchInsertVisitorInvitationAndGetInvitation}
     * @param params 搭理人列表
     * @param liveId 直播ID
     * @return
     */
    @Deprecated
    int batchInsertVisitorInvitation(List<BatchCreateNewVisitorInvitationParam> params, Long liveId);

    /**
     * 批量新增访客邀请绑定关系 并返回添加成功的邀请关系
     * {@link #batchInsertVisitorInvitation} 的升级版本
     * @param params
     * @param liveId
     * @return
     */
    List<LiveVisitorInvitationDto> batchInsertVisitorInvitationAndGetInvitation(List<BatchCreateNewVisitorInvitationParam> params, Long liveId);

    /**
     * 跟新直播状态结束
     * @param liveId 直播ID
     * @return 跟新人数
     */
    Integer updateLiveStatusEnd(Long liveId);

    /**
     * 查询直播ID对应绑定代理人人数
     * @param liveIdList 直播ID集合
     * @return key：直播ID，value：绑定代理人人数
     */
    Map<Long, Long> getLiveAgentInvitationNum(List<Long> liveIdList);

    /**
     * 获取当前用户绑定代理人ID
     * @param liveId 直播ID
     * @param bizUserId 业务方用户ID
     * @param bizType 业务类型
     * @see cn.com.duiba.kjy.livecenter.api.enums.live.BizTypeApiEnum
     * @return 绑定代理人ID
     */
    Long findInvitationAgentIdByBiz(Long liveId, String bizUserId, Integer bizType);

    /**
     * 获取代理人邀请人数
     * @param liveId 直播id
     * @param agentIds 直播代理人id集合
     * @param directly 是否直接邀请（非必传）: 0-间接邀请，1-直接邀请
     * @return key：代理人id value：代理人邀请人数
     */
    Map<Long, Long> countAgentInviteNum(Long liveId, Set<Long> agentIds, Integer directly);

    /**
     * 查询第一个绑定的不是审核公司的公司ID
     * @param liveVisitorId 直播用户ID
     * @param authCompanyId 审核公司ID
     * @return 第一个绑定的不是审核公司的公司ID
     */
    Long getFirstNonAuthCompanyId(Long liveVisitorId, Long authCompanyId);
}
