package cn.com.duiba.kjy.livecenter.api.remoteservice.black;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.black.LiveBlackListDto;
import cn.com.duiba.kjy.livecenter.api.param.black.LiveBlackListDtoSearchParam;

import java.util.List;

/**
 * 直播黑名单
 * @author lizhi
 * @date 2020/7/30 10:07 AM
 */
@AdvancedFeignClient
public interface RemoteLiveBlackListService {

    /**
     * 查询在黑名单里的用户
     * @param liveUserIds 需要校验的直播用户ID集合
     * @return 在黑名单里的用户ID集合
     */
    List<Long> findByLiveUserIds(List<Long> liveUserIds);

    /**
     * 批量新增
     * @param list 直播黑名单
     * @return 执行结果
     */
    int batchInsert(List<LiveBlackListDto> list);

    /**
     * 批量物理删除
     * @param liveUserIds 直播用户ID集合
     * @return 执行结果
     */
    int batchDelete(List<Long> liveUserIds);

    /**
     * 根据主键id查询
     * @param id 主键id
     * @return 直播黑名单用户对象
     */
    LiveBlackListDto findById(Long id);

    /**
     * 根据直播用户id查询直播黑名单
     * @param param 查询参数
     * @return 直播黑名单用户
     */
    List<LiveBlackListDto> findByCondition(LiveBlackListDtoSearchParam param);

    /**
     * 根据直播用户id查询直播黑名单
     * @param param 查询参数
     * @return 直播黑名单用户
     */
    int countByCondition(LiveBlackListDtoSearchParam param);


}
