package cn.com.duiba.kjy.livecenter.api.remoteservice.choice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.choice.ChoiceResourceRelationDto;
import cn.com.duiba.kjy.livecenter.api.param.choice.ChoiceResourceRelationParam;

import java.util.List;

/**
 * @author dugq
 * @date 2020/12/9 5:30 下午
 */
@AdvancedFeignClient
public interface RemoteChoiceResourceRelationService {
    /**
     * 查询一个问题下配置的所有关联资料
     * @param questionId 问题ID
     * @return 关联资料列表
     */
    List<ChoiceResourceRelationDto> selectByQuestionId(Long questionId);

    /**
     * 查询关联某资料的
     * @param resourceId 资料ID
     * @return 关联此资料的所有记录
     */
    List<ChoiceResourceRelationDto> selectByResourceId(Long resourceId);

    /**
     * 查询指定选项所关联的资料
     * @param answerId 选项ID
     * @return 关联资料详情
     */
    ChoiceResourceRelationDto selectByAnswerIdId(Long answerId);


    /**
     * 查询一个资料被关联了在了多少个选项上。
     * @param resourceId 资料ID
     * @return 被关联的数量
     */
    Long selectCountByResourceId(Long resourceId);

    /**
     * 新增关联资料。先删除该选项已经关联的资料，再新增资料。
     */
    int insert(ChoiceResourceRelationDto entity);

    /**
     * 批量处理一个投票下的所有选项和资料的关联关系
     * @param choiceResourceRelationParams 选项和关联资料的关系
     * @param questionId 投票的问题ID
     * @return 处理的数量
     */
    int batchInsert(Long questionId ,List<ChoiceResourceRelationParam> choiceResourceRelationParams);

    /**
     * 删除一个投票的所有选项
     * @param questionId 问题ID
     * @return 删除的数量
     */
    int deleteByQuestionId(Long questionId);

    /**
     * 删除指定选项关联的资料
     * @param answerId 选项ID
     * @return 是否删除
     */
    int deleteByAnswerId(Long answerId);
}
