package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.livecenter.api.dto.live.LiveVisitorQrcodeDto;

import java.util.List;
import java.util.Map;

/**
 * @author xuzhigang
 * @date 2020/9/19 9:56 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveVisitorQrcodeService {
    /**
     * 根据liveId和visitorId查询小程序码
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码
     */
    String getMpQrcodeUrl(Long liveId, Long visitorId);

    /**
     * 获取访客小程序码 缓存10min
     *
     * @param liveId 直播id
     * @param visitorId 访客id
     * @return 小程序码
     */
    String getMpQrcodeUrlCache(Long liveId, Long visitorId);

    /**
     * 绑定生成的小程序码
     *
     * @param qrcodeId  小程序码id
     * @param liveId    直播id
     * @param visitorId 访客id
     * @return 小程序码url
     */
     boolean bindMpQrcodeByQrcdeId(Long qrcodeId, Long liveId, Long visitorId);

    /**
     * 根据直播id和访客用户id集合获取小程序链接
     * @param liveId 直播id
     * @param visitorIds 访客id集合
     * @return key：访客id value：小程序码链接
     */
     Map<Long, String> getQrCodeByLiveAndVisitors(Long liveId, List<Long> visitorIds);

    /**
     * 批量插入访客小程序码信息
     * @param list 小程序码信息集合
     * @return 插入行数
     */
     int batchInsert(List<LiveVisitorQrcodeDto> list);
}
