package cn.com.duiba.kjy.livecenter.api.enums.clue;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 直播线索类型枚举
 *
 * @author xuzhigang
 * @date 2020/8/31 1:53 下午
 **/
@Getter
@AllArgsConstructor
public enum LiveClueTypeEnum {
    /**
     * 中奖权益
     */
    LOTTERY(1, "中奖"),

    /**
     * 免费领权益
     */
    FREE_GET(2, "免费领"),

    /**
     * 目前只有表单资料
     */
    REGISTRATION(3, "报名"),

    /**
     * 免费领资料
     */
    RECEIVE_RESOURCE(4, "领取干货资料"),

    ADVICE(5, "咨询"),

    /**
     * 除了表单资料与免费领之外的资料
     */
    RESOURCE(6, "查看资料"),

    QUESTION(7, "提问"),

    CHOICE_QUESTION(8, "投票"),

    NO_CLUE(9, "无行为"),

    NOT_WATCHED(10, "未观看");

    private Integer type;

    private String desc;
}
