package cn.com.duiba.kjy.livecenter.api.remoteservice.agent;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.agent.LiveAgentRelatedDto;
import cn.com.duiba.live.clue.service.api.param.agent.LiveAgentRelatedSearchParam;

import javax.annotation.Nonnull;
import java.util.List;

/**
 * @author liuchao1
 * @version 1.0
 * @date 2020/12/7 17:10
 */
@AdvancedFeignClient
public interface RemoteLiveAgentRelatedService {

    /**
     * 根据公司和代理人查询
     * @param agentId 代理人ID
     * @param companyId 公司ID
     * @return 关联关系
     */
    LiveAgentRelatedDto selectByAgentCompanyWithCache(Long agentId, Long companyId);

    /**
     * 根据公司和代理人查询
     * @param liveUserId 代理人直播用户ID
     * @param companyId 公司ID
     * @return 关联关系
     */
    LiveAgentRelatedDto selectByUserCompany(Long liveUserId, Long companyId);

    /**
     * 批量查询代理人的公司及团队ID信息
     * @param agentIds 代理人id集合
     * @return 公司及团队ID信息
     */
    List<LiveAgentRelatedDto> selectListByAgentIds(List<Long> agentIds);

    /**
     * 分页查询
     * @param param 分页查询参数
     * @return 关联关系
     */
    List<LiveAgentRelatedDto> selectPage(LiveAgentRelatedSearchParam param);

    /**
     * 查询记录数
     * @param param 参数
     * @return 满足条件的条数
     */
    long selectCount(LiveAgentRelatedSearchParam param);

    /**
     * 根据代理人ID，查询代理人公司及团队ID
     * @param agentId 代理人ID
     * @return 绑定的公司及团队ID集合
     */
    List<LiveAgentRelatedDto> selectListByAgentId(Long agentId);

    /**
     * 根据代理人ID，查询代理人公司及团队ID
     * @param liveUserId 代理人ID
     * @return 绑定的公司及团队ID集合
     */
    List<LiveAgentRelatedDto> selectListByUserId(Long liveUserId);

    /**
     * 查询公司下代理人用户ID
     * @param companyId 公司ID
     * @param agentIdList 代理人ID
     * @return 代理人ID及用户ID集合
     */
    @Nonnull
    List<LiveAgentRelatedDto> selectListByCompanyAgents(Long companyId, List<Long> agentIdList);

}
