package cn.com.duiba.kjy.livecenter.api.dto.clue;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 直播用户线索es简单对象
 * @author xuzhigang
 * @date 2020-12-1 9:27
 **/
@Data
public class LiveUserClueEsSimpleDto implements Serializable {
    private static final long serialVersionUID = -8573843946370713150L;

    /**
     * 直播间id
     */
    private Long liveId;

    /**
     * 代理人id 访客邀请人
     */
    private Long agentId;

    /**
     * 用户行为列表
     * @see cn.com.duiba.kjy.livecenter.api.enums.clue.LiveVisitorActionEnums
     */
    private List<Integer> actionTypeList;

    /**
     * 已读标识 0：未读 1：已读
     * @see cn.com.duiba.kjy.livecenter.api.enums.BooleanEnum
     */
    private Integer readFlag;
}
