package cn.com.duiba.kjy.livecenter.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * 直播用户服务
 * @author 周舟
 * @date 2020-3-28 10:22:31
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteLiveUserService {

    /**
     * 根据用户id 获取公司id
     * @param liveUserId
     * @return
     */
    Long findAdminCompanyIdByUserId(Long liveUserId);

    /**
     * 根据访客用户id  获取客集集系统的邀请人业务id
     * @param visitorLiveUserId  客集集访客在直播系统的liveUserId
     * @param liveId 直播系统的id
     * @return 客集集代理邀请人 在直播系统的tb_live_user.bizUserId(即客集集系统的 tb_users.id)
     */
    String  findInvitorUserId4Kjj(Long visitorLiveUserId,Long liveId);

}
