package cn.com.duiba.kjy.livecenter.api.remoteservice.invitation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author zhanghuifeng
 * date 2020/4/4-2:57 下午
 */
@AdvancedFeignClient
public interface RemoteLiveSubscribeService {

    /**
     * 新增关注记录
     * @param liveUserId 关注用户ID
     * @param liveId 直播ID
     * @return 新增数量
     */
    int insert(Long liveUserId, Long liveId);

    /**
     * 获取用户是否关注直播间
     * @param liveUserId 用户ID
     * @param companyId 公司ID
     * @return 是否关注
     */
    boolean findSubscribeState(Long liveUserId, Long companyId);

}
