package cn.com.duiba.kjy.livecenter.api.remoteservice.live;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.normal.service.api.dto.live.LiveAgentQrCodeDto;

/**
 * 直播带人二维码rpc服务
 * @author 吴文哲
 * @date 2020-04-11 16:31
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentQrCodeService {

    /**
     * 获取代理人最近一场未结束的直播的 小程序码
     * @param agentId 代理人ID
     * @return 代理人小程序码信息
     */
    LiveAgentQrCodeDto getLastNotEndLiveQrCode(Long agentId);

    /**
     * 重新生成小程序码
     * @param id 主键
     */
    void rebuildQrCode(Long id);

    /**
     * 重新获取二维码
     * @param liveId 直播id
     * @param companyId 公司id
     * @param agentId 代理人id
     * @return 二维码oss地址
     */
    String reGetQrCode(Long liveId, Long companyId, Long agentId);

}
